Attribute VB_Name = "Helpers"
Option Explicit

Public Function FormatMinsSecs(digit As Integer) As String
    ' Basically adds a digit if necessary.
    ' If this was a "mission-critical" clock, this
    ' stuff would be done inline.
    
    If digit < 10 Then
        FormatMinsSecs = "0" & CStr(digit)
    Else
        FormatMinsSecs = CStr(digit)
    End If
    
End Function
' Not necessary
Public Function FormatHours(digit As Integer) As String
    
    If digit < 10 Then
        FormatHours = " " & CStr(digit)
    Else
        FormatHours = CStr(digit)
    End If
    
End Function

Public Function ValidateTimeStr(timeStr As String, Optional lowLimit As Integer = 0, Optional highLimit As Integer = 59) As Boolean
    ' Check to see that a sec, min, or hr value is OK.
    Dim num As Integer
        
    ' Text control should limit to two characters
    If timeStr Like "##" Or timeStr Like "#" Then
        num = CInt(timeStr)
        If num >= lowLimit And num <= highLimit Then
            ValidateTimeStr = True
        End If
    Else
        ValidateTimeStr = False
    End If
    
End Function

Public Function ConvertToMilitary(hour As Integer, Optional PM As Boolean = True) As Integer
    If PM Then
        If Not hour = 12 Then
            ConvertToMilitary = hour + 12
        Else
            ConvertToMilitary = 12
        End If
    Else ' AM
        If Not hour = 12 Then
            ConvertToMilitary = hour
        Else
            ConvertToMilitary = 24
        End If
    End If
End Function

